#ifndef _INIT_CPP
#define _INIT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool InitializeApp(void)
{
    LoadString(ghAppInstance, IDS_APPCOPYRIGHT, gsAppCopyRight, sizeof(gsAppCopyRight));
    LoadString(ghAppInstance, IDS_FILEVERSION, gsFileVersion, sizeof(gsFileVersion));
    LoadString(ghAppInstance, IDS_TITLECAPTION, gsTitleCaption, sizeof(gsTitleCaption));
    LoadString(ghAppInstance, IDS_REGISTRYKEY, gsRegistryKey, sizeof(gsRegistryKey));

	InitializeCRCTable();

	memset(&MDI, 0, sizeof(MDI));
	memset(&gServer, 0, sizeof(gServer));
	
	if(!GetRegistryValues())
	{
		MessageBox(GetActiveWindow(), "Failed to get registry values.", gsTitleCaption, 0);
        return false;
	}

	if(!OpenLogFile())
	{
		MessageBox(GetActiveWindow(), "Failed to open log file.", gsTitleCaption, 0);
		return false;
	}

	if(!gServer.Initialize(giMaxClients))
    {
        WriteSysLog("Failed to Initialize the CSockSrvr.");
        return false;
    }

	gServer.SetNextClientID(giNextClientID);

	if((CCI = (_ConnectedClientInfo *) calloc(giMaxClients, sizeof(_ConnectedClientInfo))) == NULL)
    {
        WriteSysLog("Failed to Initialize the ClientInfo structure.");
        return false;
    }

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool UninitializeApp(void)
{
	SaveRegistryValues();

	if(!gServer.UnInitialize())
    {
        WriteSysLog("Failed to UnInitialize the CSockSrvr.");

        return 0;
    }

	free(CCI);

	CloseLogFile();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
